<?php
include "includes/header.php";

// Caminho do arquivo JSON
$jsonFile = 'alerta_status.json';

// Carrega os dados atuais ou cria estrutura padrão
if (file_exists($jsonFile)) {
    $config = json_decode(file_get_contents($jsonFile), true);
} else {
    $config = [
        "alerta_vencimento_ativo" => true,
        "mensagem_vencimento_hoje" => "Sua assinatura vence hoje!",
        "mensagem_vencimento_dias" => "Sua assinatura vence em %d dia(s)!"
    ];
    file_put_contents($jsonFile, json_encode($config, JSON_PRETTY_PRINT));
}

// Processa o formulário
if (isset($_POST["submit"])) {
    $config = [
        "alerta_vencimento_ativo" => isset($_POST["alerta_vencimento_ativo"]),
        "mensagem_vencimento_hoje" => $_POST["mensagem_vencimento_hoje"],
        "mensagem_vencimento_dias" => $_POST["mensagem_vencimento_dias"]
    ];
    
    file_put_contents($jsonFile, json_encode($config, JSON_PRETTY_PRINT));
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}
?>

<style>
    .card-modern {
        border-radius: 1.2rem;
        overflow: hidden;
        box-shadow: 0 8px 20px rgba(0,0,0,0.15);
        transition: transform 0.2s ease, box-shadow 0.3s ease;
    }
    .card-modern:hover {
        transform: translateY(-3px);
        box-shadow: 0 12px 28px rgba(0,0,0,0.25);
    }
    .card-header-modern {
        background: linear-gradient(135deg, #ff9800, #f44336);
        color: #fff;
    }
    .form-control-lg {
        border-radius: 0.7rem;
        padding: 0.8rem 1.2rem;
        font-size: 1rem;
    }
    .custom-btn-glow {
        border-radius: 0.7rem;
        font-weight: 600;
        box-shadow: 0 0 12px rgba(0,255,128,0.4);
        transition: all 0.3s ease;
    }
    .custom-btn-glow:hover {
        box-shadow: 0 0 18px rgba(0,255,128,0.7);
        transform: scale(1.02);
    }
    .toast-modern {
        border-radius: 0.7rem;
        overflow: hidden;
    }
</style>

<div class="container py-5">
    <div class="row justify-content-center animate__animated animate__fadeInUp">
        <div class="col-md-8 col-lg-6">
            <div class="card card-modern">
                <div class="card-header card-header-modern text-center py-4">
                    <h2 class="mb-0 fs-3"><i class="fas fa-bell me-2 fa-shake"></i> Mensagem Vencimento⚡</h2>
                </div>
                <div class="card-body p-5 bg-light">
                    <form method="post">
                        <div class="mb-4 form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="alerta_vencimento_ativo" name="alerta_vencimento_ativo" 
                                   <?= $config["alerta_vencimento_ativo"] ? 'checked' : '' ?>>
                            <label class="form-check-label fw-semibold" for="alerta_vencimento_ativo">
                                <i class="fas fa-power-off me-2 text-success"></i> Ativar alertas de vencimento
                            </label>
                        </div>
                        
                        <div class="mb-4">
                            <label for="mensagem_vencimento_hoje" class="form-label fw-semibold">
                                <i class="fas fa-calendar-day me-2 text-danger"></i> Mensagem para vencimento HOJE:
                            </label>
                            <input type="text" class="form-control form-control-lg border-danger" 
                                   id="mensagem_vencimento_hoje" name="mensagem_vencimento_hoje" 
                                   value="<?= htmlspecialchars($config["mensagem_vencimento_hoje"]) ?>" 
                                   placeholder="⚠️ Sua assinatura expira hoje! Renove já!">
                            <small class="text-muted"><i class="fas fa-lightbulb me-1"></i> Você pode usar emojis 🎯</small>
                        </div>
                        
                        <div class="mb-5">
                            <label for="mensagem_vencimento_dias" class="form-label fw-semibold">
                                <i class="fas fa-calendar-week me-2 text-primary"></i> Mensagem para vencimento FUTURO:
                            </label>
                            <input type="text" class="form-control form-control-lg border-primary" 
                                   id="mensagem_vencimento_dias" name="mensagem_vencimento_dias" 
                                   value="<?= htmlspecialchars($config["mensagem_vencimento_dias"]) ?>" 
                                   placeholder="⏳ Sua assinatura vence em %d dia(s)!">
                            <small class="text-muted"><i class="fas fa-info-circle me-1"></i> O símbolo %d será substituído pelo número de dias 🔢</small>
                        </div>
                        
                        <div class="d-grid">
                            <button class="btn btn-success btn-lg custom-btn-glow" name="submit" type="submit">
                                <i class="fas fa-save me-2"></i> Salvar Configurações
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card-footer bg-white text-center py-3">
                    <small class="text-muted"><i class="fas fa-info-circle me-1"></i> As alterações têm efeito imediato ⚡</small>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if (isset($_GET['status']) && $_GET['status'] == 1): ?>
    <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 1080">
        <div class="toast show shadow-lg border-0 animate__animated animate__fadeInUp" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header bg-gradient-success text-white rounded-top">
                <i class="fas fa-check-circle me-2 fa-bounce"></i>
                <strong class="me-auto">Sucesso!</strong>
                <small class="text-light">Agora</small>
                <button type="button" class="btn-close btn-close-white ms-2 mb-1" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
           <div class="toast-body fs-6 text-dark">
    Configurações salvas com sucesso! 🎉✨
</div>
            </div>
        </div>
    </div>

    <style>
        /* Gradiente no header */
        .bg-gradient-success {
            background: linear-gradient(45deg, #28a745, #20c997);
        }

        /* Efeito glow */
        .toast {
            border-radius: 1rem;
            overflow: hidden;
            animation: popUp 0.6s ease;
        }

        @keyframes popUp {
            0% { transform: scale(0.9); opacity: 0; }
            100% { transform: scale(1); opacity: 1; }
        }

        /* Brilho suave */
        .toast-body {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { text-shadow: 0 0 4px rgba(40, 167, 69, 0.4); }
            50% { text-shadow: 0 0 12px rgba(40, 167, 69, 0.9); }
            100% { text-shadow: 0 0 4px rgba(40, 167, 69, 0.4); }
        }
    </style>
<?php endif; ?>
<?php include "includes/footer.php"; ?>
