<?php
header("Cache-Control: no-cache, no-store, must-revalidate"); 
header("Pragma: no-cache"); 
header("Expires: 0"); 
include "includes/header.php";
require_once("qrlib.php"); // Biblioteca PHP QR Code
?>

<style>
/* ================= Estilos ================= */
.custom-button { padding:10px 20px; border-radius:5px; transition:0.3s; }
.custom-button:hover { opacity:0.9; }
.custom-input { color:#007bff; border:1px solid #ced4da; border-radius:4px; padding:8px 12px; width:100%; box-sizing:border-box; }
.card { border-radius:10px; box-shadow:0 4px 12px rgba(0,0,0,0.1); margin-bottom:20px; }
.card-header { background:#f8f9fa; border-bottom:1px solid #e9ecef; padding:15px 20px; border-top-left-radius:10px; border-top-right-radius:10px; }
.card-title { color:#343a40; font-weight:600; display:flex; align-items:center; justify-content:center; }
.card-title i { margin-right:10px; font-size:1.25rem; }
.btn-action { background:#28a745; color:white; border:none; padding:10px 20px; border-radius:5px; cursor:pointer; transition:0.3s; margin-top:15px; }
.btn-action:hover { background:#218838; }
.mode-selection-card { cursor:pointer; border:2px solid #e9ecef; transition:0.3s; padding:25px; text-align:center; background:#fff; border-radius:10px; display:flex; flex-direction:column; justify-content:center; align-items:center; min-height:180px; }
.mode-selection-card:hover { border-color:#007bff; box-shadow:0 6px 15px rgba(0,0,0,0.15); transform:translateY(-3px); }
.mode-selection-card.selected { border-color:#007bff; box-shadow:0 6px 15px rgba(0,123,255,0.2); background:#e6f2ff; }
.mode-selection-card .icon { font-size:3.5rem; margin-bottom:15px; color:#6c757d; }
.mode-selection-card.selected .icon { color:#007bff; }
.mode-selection-card h4 { margin-bottom:10px; color:#343a40; font-weight:600; }
.mode-selection-card p { font-size:0.95rem; color:#6c757d; }
#qr-code-form, #image-upload-form, #pix-form { display:none; margin-top:30px; padding:20px; border:1px solid #e9ecef; border-radius:8px; background:#fcfcfc; }
.alert-success { color:#155724; background:#d4edda; border-color:#c3e6cb; padding:10px; margin-bottom:15px; border-radius:5px; }
.alert-danger { color:#721c24; background:#f8d7da; border-color:#f5c6cb; padding:10px; margin-bottom:15px; border-radius:5px; }
.alert-info { color:#0c5460; background:#d1ecf1; border-color:#bee5eb; padding:10px; margin-bottom:15px; border-radius:5px; }
.qr-history img { margin:5px; border:1px solid #e9ecef; border-radius:5px; max-width:150px; }
</style>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Sistema Pix Ou QR Code 📱</h1>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary card-title">
                <i class="fa fa-hand-pointer"></i> Escolha o Modo de Operação
            </h6>
        </div>
        <div class="card-body">
            <p class="text-center mb-4">Selecione como você deseja gerenciar seu QR Code:</p>

            <form id="modeSelectionForm">
                <input type="hidden" name="selected_mode" id="selectedModeInput" value="">

                <div class="row justify-content-center">
                    <!-- Card Upload de Imagem -->
                    <div class="col-md-5 mb-3">
                        <div class="card mode-selection-card" data-mode="image">
                            <div class="card-body">
                                <div class="icon">🖼️</div>
                                <h4>QR Code Via imagem</h4>
                                <p>Imagem existente do seu QR Code</p>
                            </div>
                        </div>
                    </div>

                    <!-- Card Pix -->
                    <div class="col-md-5 mb-3">
                        <div class="card mode-selection-card" data-mode="pix">
                            <div class="card-body">
                                <div class="icon">💰</div>
                                <h4>Sistema Pix</h4>
                                <p>Chave, telefone, e-mail ou link Pix</p>
                            </div>
                        </div>
                    </div>
                </div>
            </form>

            <hr class="my-4">

            <!-- Formulário Upload -->
            <div id="image-upload-form">
                <h5 class="text-primary mb-3">Carregar Imagem de QR Code (PNG) ⬆️</h5>
                <form method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="image">Selecione a imagem (PNG)</label>
                        <input type="file" name="image" id="image" accept="image/png" class="form-control-file" required>
                    </div>
                    <button type="submit" class="btn btn-action"><i class="fa fa-upload"></i> Enviar Imagem</button>
                </form>

                <?php
                if ($_SERVER["REQUEST_METHOD"]=="POST" && isset($_FILES["image"])) {
                    $fileType=$_FILES["image"]["type"];
                    if($fileType==="image/png") {
                        $uploadPath='./api/qr/';
                        if(!is_dir($uploadPath)) mkdir($uploadPath,0777,true);
                        $filePath=$uploadPath.'qr_image_'.time().'.png';
                        if(move_uploaded_file($_FILES["image"]["tmp_name"],$filePath)) {
                            echo '<div class="alert alert-success">✅ Imagem enviada com sucesso!</div>';
                        } else {
                            echo '<div class="alert alert-danger">❌ Falha ao enviar imagem.</div>';
                        }
                    } else {
                        echo '<div class="alert alert-danger">⚠️ Apenas arquivos PNG são permitidos.</div>';
                    }
                }
                ?>
            </div>

            <!-- Formulário Pix -->
            <div id="pix-form">
                <h5 class="text-primary mb-3">Sistema Pix💳</h5>
                <form method="post">
                    <div class="form-group">
                        <label for="pix_link">Insira qualquer chave ou link Pix:</label>
                        <input type="text" id="pix_link" name="pix_link" class="form-control custom-input" placeholder="Ex: número, e-mail ou link Pix" required>
                    </div>
                    <button type="submit" class="btn btn-action"><i class="fa fa-qrcode"></i> Gerar QR Code Pix</button>
                </form>

                <?php
                if($_SERVER["REQUEST_METHOD"]=="POST" && isset($_POST["pix_link"])) {
                    $pixLink = trim($_POST["pix_link"]); 
                    if(!empty($pixLink)) {
                        $uploadPath='./api/qr/';
                        if(!is_dir($uploadPath)) mkdir($uploadPath,0777,true);
                        // Salva com timestamp para histórico
                        $timestamp = time();
                        $filePath = $uploadPath.'qr_pix_'.$timestamp.'.png';

                        $qr = QRCode::getMinimumQRCode($pixLink, QR_ERROR_CORRECT_LEVEL_L);
                        $im = $qr->createImage(6,8);
                        imagepng($im,$filePath);
                        imagedestroy($im);

                        echo '<div class="alert alert-success">✅ QR Code Pix gerado!<br><img src="'.$filePath.'" alt="QR Code Pix" style="max-width:200px;"></div>';
                    } else {
                        echo '<div class="alert alert-danger">⚠️ Insira uma chave ou link válido!</div>';
                    }
                }
                ?>

                <h6 class="mt-3">Histórico de QR Codes Pix</h6>
                <div class="qr-history">
                    <?php
                    $files = glob('./api/qr/qr_pix_*.png');
                    if($files) {
                        rsort($files); // Mais recente primeiro
                        foreach($files as $file) {
                            echo '<img src="'.$file.'" alt="QR Pix">';
                        }
                    } else {
                        echo '<p>Nenhum QR Code gerado ainda.</p>';
                    }
                    ?>
                </div>
            </div>

        </div>
    </div>
</div>

<?php include "includes/footer.php"; ?>

<script>
document.addEventListener('DOMContentLoaded', function(){
    const modeCards = document.querySelectorAll('.mode-selection-card');
    const imageForm = document.getElementById('image-upload-form');
    const pixForm = document.getElementById('pix-form');
    const selectedInput = document.getElementById('selectedModeInput');

    function showForm(mode){
        imageForm.style.display='none';
        pixForm.style.display='none';
        if(mode==='image') imageForm.style.display='block';
        else if(mode==='pix') pixForm.style.display='block';
        modeCards.forEach(card=>card.classList.remove('selected'));
        modeCards.forEach(card=>{ if(card.dataset.mode===mode) card.classList.add('selected'); });
        selectedInput.value=mode;
    }

    modeCards.forEach(card=>{card.addEventListener('click',function(){showForm(this.dataset.mode);});});
});
</script>
