<?php
// =========================
// live_game_manager.php
// =========================
ini_set('display_errors', 0);
error_reporting(E_ALL);
if (session_status() === PHP_SESSION_NONE) session_start();

// =========================
// Verificação de Login (simples)
// =========================
if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

// =========================
// Conexão SQLite
// =========================
try {
    $db_path = __DIR__ . '/api/studiolivecode.db';
    $sqlite = new PDO("sqlite:$db_path");
    $sqlite->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Cria tabela se não existir
    $sqlite->exec("CREATE TABLE IF NOT EXISTS live_game_url (
        id INTEGER PRIMARY KEY,
        url TEXT NOT NULL
    )");

    // Garante um registro inicial
    $sqlite->exec("INSERT OR IGNORE INTO live_game_url (id, url) VALUES (1, 'https://seunome.com.br/placeholder')");
} catch (PDOException $e) {
    die("Erro ao conectar com o banco de dados.");
}

// =========================
// Salvar URL via POST
// =========================
$status = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['game_url'])) {
    $newUrl = trim($_POST['game_url']);
    if (!empty($newUrl)) {
        $stmt = $sqlite->prepare("UPDATE live_game_url SET url = :url WHERE id = 1");
        $stmt->bindValue(':url', $newUrl, PDO::PARAM_STR);
        $status = $stmt->execute() ? 'success' : 'error';
    }
}

// =========================
// Pega a URL atual
// =========================
$currentUrl = '';
$stmt = $sqlite->query("SELECT url FROM live_game_url WHERE id = 1");
if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $currentUrl = htmlspecialchars($row['url'], ENT_QUOTES, 'UTF-8');
}

// =========================
// Detecta modo APP
// =========================
$isApp = false;
if (isset($_GET['app']) && $_GET['app'] == "1") $isApp = true;
elseif (isset($_SERVER['HTTP_USER_AGENT']) && stripos($_SERVER['HTTP_USER_AGENT'], 'UniTV') !== false) $isApp = true;
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Sports Guide</title>
<script src="https://cdn.tailwindcss.com"></script>
<style>
body, html { 
    margin:0; 
    padding:0; 
    height:100%; 
    width:100%; 
    background:black; 
}
.live-iframe, .preview-iframe {
    border:none;
    width:100%;
}
</style>
</head>
<body class="bg-black text-white">

<?php if ($isApp): ?>
    <!-- MODO APP (WebView fullscreen no UniTV) -->
    <iframe id="live-game-iframe"
        src="<?php echo $currentUrl; ?>"
        allow="autoplay; fullscreen"
        class="live-iframe h-screen w-full">
    </iframe>

<?php else: ?>
    <!-- MODO PAINEL WEB -->
    <div class="flex flex-col min-h-screen p-4 sm:p-6 lg:p-8">
        <div class="w-full max-w-4xl mx-auto">

            <!-- Botão Voltar -->
            <div class="mb-6">
                <a href="dash.php" 
                   class="inline-block px-5 py-3 rounded-2xl bg-gray-700 text-white font-semibold hover:bg-gray-600 transition shadow-lg">
                   ⬅️ Voltar para Dashboard
                </a>
            </div>

            <!-- Título -->
            <h1 class="text-2xl sm:text-3xl lg:text-4xl font-extrabold text-center mb-6">
                Jogos ao Vivo Direto no Aplicativo
            </h1>

            <!-- URL Atual -->
            <div class="mb-6 text-center">
                <h2 class="text-base sm:text-lg font-medium mb-2">URL Atual:</h2>
                <p id="current-url-display" class="break-words bg-gray-800 rounded-xl p-4 font-mono text-sm shadow-inner">
                    <?php echo $currentUrl; ?>
                </p>
            </div>

            <!-- Formulário -->
            <form id="live-game-form" method="POST" action="" class="space-y-5">
                <div>
                    <label for="game-url" class="block font-medium mb-2">Novo URL:</label>
                    <input type="url" id="game-url" name="game_url" placeholder="https://dominio.com" required
                        class="w-full rounded-xl px-4 sm:px-5 py-3 bg-gray-900 text-white border border-gray-600 focus:outline-none focus:border-purple-400 focus:ring-2 focus:ring-purple-400 transition-all duration-300 text-sm sm:text-base">
                </div>
                <button type="submit" class="w-full py-3 px-6 rounded-3xl font-semibold uppercase tracking-wider text-white bg-purple-700 hover:bg-purple-800 transition text-sm sm:text-base">
                    💾 Salvar URL
                </button>
                <?php if ($status === 'success'): ?>
                    <p class="text-center font-medium mt-4 text-green-400 animate-pulse">
                        ✅ URL salva com sucesso!
                    </p>
                <?php elseif ($status === 'error'): ?>
                    <p class="text-center font-medium mt-4 text-red-400 animate-pulse">
                        ❌ Erro ao salvar a URL.
                    </p>
                <?php endif; ?>
            </form>

            <!-- Visualização do Jogo -->
            <div class="w-full p-4 rounded-3xl bg-gray-800 shadow-2xl mt-8">
                <h2 class="text-lg sm:text-xl font-bold text-center mb-4">Visualização do Jogo</h2>
                <div class="aspect-video w-full">
                    <iframe id="live-game-iframe-preview"
                        src="<?php echo $currentUrl; ?>"
                        class="preview-iframe w-full h-full rounded-xl bg-black"
                        allow="autoplay; fullscreen">
                    </iframe>
                </div>
            </div>
        </div>
    </div>

    <script>
    // Atualiza preview após salvar
    document.getElementById('live-game-form').addEventListener('submit', function(e) {
        setTimeout(() => {
            const newUrl = document.getElementById('game-url').value;
            if(newUrl){
                document.getElementById('live-game-iframe-preview').src = newUrl;
                document.getElementById('current-url-display').textContent = newUrl;
            }
        }, 200);
    });
    </script>
<?php endif; ?>

</body>
</html>
