<?php
// =======================
// Sesso segura
// =======================
if (session_status() === PHP_SESSION_NONE) {
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_samesite', 'Strict');
if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
ini_set('session.cookie_secure', 1);
}
session_start();
}

// =======================
// Headers de segurana
// =======================
header_remove("X-Powered-By");
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");
header("Referrer-Policy: no-referrer-when-downgrade");
header("Content-Security-Policy: default-src 'self' https: data: 'unsafe-inline'; script-src 'self' https: 'unsafe-inline' 'unsafe-eval'; style-src 'self' https: 'unsafe-inline';");

// =======================
// Regenerar ID de sesso a cada 15 minutos
// =======================
if (!isset($_SESSION['CREATED'])) {
    $_SESSION['CREATED'] = time();
} elseif (time() - $_SESSION['CREATED'] > 900) {
    session_regenerate_id(true);
    $_SESSION['CREATED'] = time();
}

// =======================
// Inclui funes e garante $db
// =======================
require_once __DIR__ . "/includes/functions.php";
if (!isset($db)) {
    die("Erro: conexo com o banco de dados no encontrada.");
}

// =======================
// Cria admin padro se no existir
// =======================
$data = ["id" => "1", "username" => "admin", "password" => "admin"];
$db->insertIfEmpty("users", $data);

// =======================
// Verifica se j est logado
// =======================
if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true) {
    if ($_SESSION["name"] === "admin") {
        header("Location: user.php");
    } else {
        header("Location: dash.php");
    }
    exit;
}

// =======================
// Processa login
// =======================
$login_error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["login"])) {
    $username = trim($_POST["username"]);
    $password = $_POST["password"];

    $userData = $db->select("users", "*", "username = :username", "", [":username" => $username]);

    if ($userData) {
        $storedPassword = $userData[0]["password"];

        if ($password === $storedPassword) {
            session_regenerate_id(true);
            $_SESSION["loggedin"] = true;
            $_SESSION["name"] = $username;
            $_SESSION["user_id"] = $userData[0]["id"];

            if ($username === "admin") {
                header("Location: user.php");
            } else {
                header("Location: dash.php");
            }
            exit;
        } else {
            $login_error = "Senha incorreta!";
        }
    } else {
        $login_error = "Usurio no encontrado!";
    }

    if (method_exists($db, 'close')) {
        $db->close();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>UniTV BR</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Fontes e cones -->
<link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@500&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
:root {
  --md3-primary: #6750A4;
  --md3-on-primary: #FFFFFF;
  --md3-primary-container: #EADDFF;
  --md3-on-primary-container: #21005D;

  --md3-secondary: #625B71;
  --md3-on-secondary: #FFFFFF;
  --md3-secondary-container: #E8DEF8;
  --md3-on-secondary-container: #1D192B;

  --md3-background: #1C1B1F;
  --md3-on-background: #E6E1E5;
  --md3-surface: #1C1B1F;
  --md3-on-surface: #E6E1E5;
  --md3-outline: #79747E33;
  --md3-radius: 24px;
}

/* Reset */
* { box-sizing: border-box; margin: 0; padding: 0; }
body, html { font-family: 'Roboto', sans-serif; background: var(--md3-background); color: var(--md3-on-background); display: flex; justify-content: center; align-items: center; min-height: 100vh; position: relative; overflow: hidden; }

/* Particles */
#particles-js { position: absolute; width: 100%; height: 100%; z-index: -1; }

/* Login Box */
.login-box {
  background: var(--md3-surface);
  border-radius: var(--md3-radius);
  padding: 100px 80px;
  max-width: 560px;
  width: 95%;
  text-align: center;
  box-shadow: 0 16px 36px rgba(0,0,0,0.45), 0 0 20px rgba(103,80,164,0.2);
  border: 2px solid rgba(103,80,164,0.3);
  transition: transform 0.4s, box-shadow 0.4s, border-color 0.4s;
}
.login-box:hover {
  transform: translateY(-10px);
  box-shadow: 0 20px 44px rgba(0,0,0,0.5), 0 0 30px rgba(103,80,164,0.3);
  border-color: rgba(103,80,164,0.6);
}

/* Title */
.login-box h2 {
  font-size: 3rem;
  font-weight: 700;
  color: var(--md3-primary);
  margin-bottom: 45px;
  letter-spacing: 1.5px;
  text-shadow: 0 0 8px rgba(103,80,164,0.5);
}

/* Inputs */
.input-box { position: relative; margin-bottom: 25px; }
.input-box input {
  width: 100%;
  padding: 18px 24px;
  border-radius: var(--md3-radius);
  border: 1px solid var(--md3-outline);
  background: #2A2830;
  color: var(--md3-on-surface);
  font-size: 18px;
  transition: all 0.4s ease;
}
.input-box input:focus {
  border-color: var(--md3-primary);
  box-shadow: 0 0 12px var(--md3-primary), 0 0 20px rgba(103,80,164,0.4);
  outline: none;
}
.input-box i {
  position: absolute;
  right: 20px;
  top: 50%;
  transform: translateY(-50%);
  color: var(--md3-secondary);
  transition: all 0.3s ease;
}
.input-box input:focus + i {
  transform: translateY(-50%) scale(1.3);
  color: var(--md3-primary);
}

/* Button */
.btn-login {
  width: 100%;
  padding: 18px;
  border: none;
  border-radius: var(--md3-radius);
  background-color: var(--md3-primary);
  color: var(--md3-on-primary);
  font-weight: 700;
  font-size: 18px;
  cursor: pointer;
  box-shadow: 0 8px 18px rgba(0,0,0,0.4), 0 0 12px rgba(103,80,164,0.3);
  transition: all 0.4s ease;
}
.btn-login:hover {
  background-color: var(--md3-primary-container);
  color: var(--md3-on-primary-container);
  transform: translateY(-3px);
  box-shadow: 0 12px 24px rgba(0,0,0,0.45), 0 0 20px rgba(103,80,164,0.5);
}

/* Footer */
.footer-text { margin-top: 30px; font-size: 14px; color: var(--md3-on-surface); }
.footer-text a { color: var(--md3-primary); text-decoration: none; transition: color 0.3s ease; }
.footer-text a:hover { color: var(--md3-primary-container); }

/* Alerts */
.alert { padding: 14px; border-radius: var(--md3-radius); margin-bottom: 20px; text-align: center; }
.alert-danger { background-color: #D32F2F; color: #fff; }
.alert-success { background-color: #388E3C; color: #fff; }

/* Responsivo */
@media (max-width: 480px){
  .login-box { padding: 60px 30px; }
  .login-box h2 { font-size: 2.2rem; }
}
</style>

<script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
<script>
particlesJS("particles-js", {
  particles: {
    number: { value: 80, density: { enable: true, value_area: 800 }},
    color: { value: ["#6750A4","#EADDFF","#625B71"] },
    shape: { type: "circle" },
    opacity: { value: 0.5 },
    size: { value: 3, random: true },
    line_linked: { enable: true, distance: 120, color: "#6750A4", opacity: 0.25, width: 1 },
    move: { enable: true, speed: 2, out_mode: "out" }
  },
  interactivity: {
    events: {
      onhover: { enable: true, mode: "repulse" },
      onclick: { enable: true, mode: "push" }
    },
    modes: { repulse: { distance: 100 }, push: { particles_nb: 4 } }
  },
  retina_detect: true
});
</script>
</head>
<body>
<div id="particles-js"></div>

<div class="login-box">
  <h2>UniTV BR</h2>

  <?php if (!empty($login_error)): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($login_error, ENT_QUOTES, 'UTF-8'); ?></div>
  <?php endif; ?>

  <form method="post" action="">
    <div class="input-box">
      <label for="username" class="sr-only">Conta</label>
      <input type="text" id="username" name="username" placeholder="Conta" required>
      <i class="fas fa-user"></i>
    </div>

    <div class="input-box">
      <label for="password" class="sr-only">Senha</label>
      <input type="password" id="password" name="password" placeholder="Senha" required>
      <i class="fas fa-lock"></i>
    </div>

    <button type="submit" class="btn-login" name="login">
      <i class="fas fa-sign-in-alt"></i> Entrar
    </button>
  </form>

  <div class="footer-text">
    Editado por <a href="https://t.me/brtechprojetos" target="_blank">BR TECH</a>
  </div>
</div>
</body>
</html>
