<?php
// 🔒 Segurança de exibição de erros
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error_log.txt');

// 🔒 Sessão segura
if (session_status() === PHP_SESSION_NONE) {
ini_set('session.use_strict_mode', 1);
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_samesite', 'Strict');
ini_set('session.cookie_secure', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on');
session_start();
session_regenerate_id(true); // evita fixation
}

// Inclui funções
include(__DIR__ . '/functions.php');

// Gera token CSRF se não existir
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// 🔒 Proteção contra Path Traversal e leitura insegura
$adTypeJsonPath = realpath(__DIR__ . '/ad_type.json');
if (!$adTypeJsonPath || strpos($adTypeJsonPath, __DIR__) !== 0) {
    die("Arquivo de configuração inválido!");
}

$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true) ?? [];
$currentAdType = $adTypeData['adType'] ?? 'manual';
$adsPageUrl = ($currentAdType === 'tmdb') ? "tmdb_api.php" : "ads.php";

// 🔒 Bancos de dados com caminho seguro
$dbPaths = [
'adb'        => './api/.adb.db',
'adb3'       => './api/.db_logo.db',
'adb4'       => './api/.db_bg.db',
'studiolive' => './api/studiolivecode.db'
];
foreach ($dbPaths as $key => $path) {
if (!file_exists($path)) {
file_put_contents($path, ''); // cria vazio caso não exista
}
}

$adb        = new SQLite3($dbPaths['adb']);
$adb3       = new SQLite3($dbPaths['adb3']);
$adb4       = new SQLite3($dbPaths['adb4']);
$studiolive = new SQLite3($dbPaths['studiolive']);

// 🔒 Checagem de login segura
if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if ($_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="author" content="UniTV BR">

<!-- Bootstrap 5 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- FontAwesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- Animações -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">

<!-- Estilo customizado -->
<link href="css/simple-sidebar.css" rel="stylesheet">
<style>
:root {
  /* MD3 Color Palette (Dark Theme) */
  --md3-primary: #D0BCFF;
  --md3-on-primary: #381E72;
  --md3-primary-container: #4F378B;
  --md3-on-primary-container: #EADDFF;
  --md3-secondary: #CCC2DC;
  --md3-on-secondary: #332D41;
  --md3-secondary-container: #4A4458;
  --md3-on-secondary-container: #E8DEF8;
  --md3-tertiary: #EFB8C8;
  --md3-on-tertiary: #492532;
  --md3-tertiary-container: #633B48;
  --md3-on-tertiary-container: #FFD8E4;
  --md3-background: #1C1B1F;
  --md3-on-background: #E6E0E9;
  --md3-surface: #1C1B1F;
  --md3-on-surface: #E6E0E9;
  --md3-surface-variant: #49454F;
  --md3-on-surface-variant: #CAC4D0;
  --md3-outline: #938F99;
  --md3-shadow: #000000;
  --md3-surface-container: #211F26;
  --md3-surface-container-low: #1C1B1F;
  --md3-surface-container-high: #2B2930;
  --md3-surface-container-highest: #36343B;
  --md3-error: #F2B8B5;
  --md3-on-error: #601410;
  --md3-error-container: #8C1D18;
  --md3-on-error-container: #F9DEDC;
}

body {
    background: var(--md3-background);
    color: var(--md3-on-background);
    font-family: 'Roboto', sans-serif;
    margin: 0;
    overflow-x: hidden;
}

/* Layout */
#wrapper {
    display: flex;
    min-height: 100vh;
    flex-direction: row;
}

/* Sidebar */
#sidebar-wrapper {
    background: var(--md3-surface-container-high);
    width: 280px;
    display: flex;
    flex-direction: column;
    padding-top: 1.5rem;
    border-right: 1px solid var(--md3-outline);
    box-shadow: 4px 0 12px rgba(0, 0, 0, 0.2);
    transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1), background-color 0.4s ease;
}

.sidebar-heading {
    text-align: center;
    font-size: 1.8rem;
    font-weight: 700;
    padding: 1.5rem 1rem;
    color: var(--md3-primary);
    border-bottom: 1px solid var(--md3-outline);
    margin-bottom: 1rem;
}

/* Links */
.list-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
    padding: 0 1rem;
}

.list-group-item {
    background: transparent;
    border: none;
    color: var(--md3-on-surface);
    padding: 12px 16px;
    border-radius: 20px;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    display: flex;
    align-items: center;
    gap: 1.2rem;
    font-weight: 500;
    cursor: pointer;
    position: relative;
    overflow: hidden;
}

.list-group-item:hover {
    background-color: var(--md3-primary-container);
    color: var(--md3-on-primary-container);
    transform: translateX(4px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
}

.list-group-item i {
    font-size: 1.3rem;
    transition: all 0.3s ease;
    color: var(--md3-primary);
}

.list-group-item:hover i {
    color: var(--md3-on-primary-container);
}

/* Footer da sidebar */
.sidebar-footer {
    text-align: center;
    font-size: 0.8rem;
    color: var(--md3-outline);
    margin-top: auto;
    padding: 1rem;
}

/* Conteúdo */
#page-content-wrapper {
    flex: 1;
    padding: 2rem;
}

/* Navbar */
.navbar {
    background-color: var(--md3-surface-container);
    border-radius: 24px;
    padding: 0.8rem 1.5rem;
    margin-bottom: 2rem;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

/* Botões */
.btn {
    border-radius: 20px;
    font-weight: 500;
    padding: 0.6rem 1.4rem;
    border: none;
    text-transform: uppercase;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

.btn-primary {
    background-color: var(--md3-primary);
    color: var(--md3-on-primary);
}

.btn-primary:hover {
    background-color: var(--md3-primary-container);
    color: var(--md3-on-primary-container);
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
}

.btn-danger {
    background-color: var(--md3-error);
    color: var(--md3-on-error);
}

.btn-danger:hover {
    background-color: var(--md3-error-container);
    color: var(--md3-on-error-container);
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
}

/* Cards */
.card {
    background-color: var(--md3-surface-container);
    border-radius: 28px;
    padding: 1.5rem;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
    margin-bottom: 1.5rem;
    transition: transform 0.3s, box-shadow 0.3s;
}

.card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.3);
}

/* Ripple Effect (without JavaScript) */
.ripple {
    position: relative;
    overflow: hidden;
    transform: translate3d(0, 0, 0);
}

.ripple:after {
    content: "";
    display: block;
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    pointer-events: none;
    background-image: radial-gradient(circle, #fff 10%, transparent 10.01%);
    background-repeat: no-repeat;
    background-position: 50%;
    transform: scale(10, 10);
    opacity: 0;
    transition: transform 0.5s, opacity 1s;
}

.ripple:active:after {
    transform: scale(0, 0);
    opacity: 0.2;
    transition: 0s;
}

@media (min-width: 768px) {
    #sidebar-wrapper { margin-left: 0; }
    #page-content-wrapper { min-width: 0; width: 100%; }
}
</style>
</head>
<body>
<div class="d-flex" id="wrapper">
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">UniTV BR</div>
        <div class="list-group list-group-flush">
            <a class="list-group-item list-group-item-action" href="dash.php">
                <i class="fas fa-home"></i> Tela Inicial
            </a>
            <a class="list-group-item list-group-item-action" href="dns.php">
                <i class="fas fa-server"></i> Servidores
                </a>
                
            <a class="list-group-item list-group-item-action" href="live_game_api.php">
                <i class="fas fa-meteor"></i> Sports Guide
            </a>
            
            <a class="list-group-item list-group-item-action" href="chatbot.php">
                <i class="fas fa-robot"></i> Sistema Chatbot
            </a>
            
            <a class="list-group-item list-group-item-action" href="gerenciartestes.php">
           <i class="fas fa-check-circle"></i> Gerenciar Testes
            </a>

            <a class="list-group-item list-group-item-action" href="logo.php">
                <i class="fas fa-image animate__animated animate__fadeIn"></i> Imagem Logo
            </a>
            <a class="list-group-item list-group-item-action" href="bg.php">
                <i class="fas fa-image animate__animated animate__fadeIn"></i> Imagem Fundo
            </a>
            
                         
            
            <a class="list-group-item list-group-item-action" href="qrcode.php">
                <i class="fas fa-qrcode"></i> Sistema Pix
            </a>
            
               <a class="list-group-item list-group-item-action" href="settings.php">
                <i class="fas fa-comment-alt"></i> Vencimentos
            </a>
           
            <a class="list-group-item list-group-item-action" href="user.php">
                <i class="fas fa-user-cog"></i> Meu Perfil
            </a>
        </div>
        <div class="sidebar-footer">
        </div>
    </div>

    <!-- Conteúdo -->
    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-light">
            <button class="btn btn-primary" id="menu-toggle">
                <img src="img/logo.png" width="25" height="25" class="d-inline-block align-top" alt="">
            </button>
            <div class="ms-auto">
                <a href="logout.php" class="btn btn-md3-filled-tonal-danger">Logout</a>
                <style>
:root {
  /* Cores para o tema MD3 (Escuro) */
  --md3-error: #FFB4AB;
  --md3-on-error: #690005;
  --md3-error-container: #8C1D18;
  --md3-on-error-container: #FFDAD6;
  --md3-shadow: rgba(0, 0, 0, 0.4);
}

.btn-md3-filled-tonal-danger {
  background-color: var(--md3-error-container);
  color: var(--md3-on-error-container);
  border-radius: 20px;
  border: none;
  font-weight: 500;
  padding: 10px 24px;
  box-shadow: 0 2px 4px var(--md3-shadow);
  text-transform: uppercase;
  text-decoration: none;
  transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.btn-md3-filled-tonal-danger:hover {
  background-color: var(--md3-error);
  color: var(--md3-on-error);
  box-shadow: 0 4px 8px var(--md3-shadow);
  transform: translateY(-2px);
}

.btn-md3-filled-tonal-danger:active {
  transform: translateY(0);
}
</style>
            </div>
        </nav>

        <div class="container-fluid mt-3">
<script src="https://code.jquery.com/jquery-3.6.0.min.js" defer></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js" defer></script>

<script>
document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.ripple').forEach(btn => {
        btn.addEventListener('click', function(e) {
            const circle = document.createElement('span');
            circle.classList.add('ripple-effect');
            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            circle.style.width = circle.style.height = size + 'px';
            circle.style.left = (e.clientX - rect.left - size/2) + 'px';
            circle.style.top = (e.clientY - rect.top - size/2) + 'px';
            this.appendChild(circle);
            let start;
            function animate(timestamp) {
                if (!start) start = timestamp;
                const elapsed = timestamp - start;
                if (elapsed > 700) { circle.remove(); return; }
                requestAnimationFrame(animate);
            }
            requestAnimationFrame(animate);
        });
    });
});
</script>
</body>
</html>
