<?php
require_once("qrlib.php");

try {
    // Conexão ao banco de dados
    $pdo = new PDO('sqlite:' . __DIR__ . '/api/studiolivecode.db');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    // Log do erro em produção (não exibir para o usuário)
    error_log("Erro ao conectar ao banco de dados: " . $e->getMessage());
    header("Location: qrcode.php?status=error");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST["url"]) && !empty($_POST["url"])) {
        $url = "https://wa.me/55" . $_POST["url"];
        $qr = QRCode::getMinimumQRCode($url, QR_ERROR_CORRECT_LEVEL_L);
        $im = $qr->createImage(6, 8);

        $dir = __DIR__ . "/api/qr/";
        if (!is_dir($dir)) {
            if (!mkdir($dir, 0775, true)) {
                // Log do erro em produção
                error_log("Erro: Não foi possível criar o diretório " . $dir);
                header("Location: qrcode.php?status=error");
                exit();
            }
        }

        $filepath = $dir . "qr.png";

        if (!is_writable($dir)) {
            // Log do erro em produção
            error_log("Erro: O diretório " . $dir . " não é gravável");
            header("Location: qrcode.php?status=error");
            exit();
        }

        if (imagepng($im, $filepath)) {
            try {
                $stmt = $pdo->prepare("INSERT INTO qrcode (title, url) VALUES (?, ?)");
                $stmt->execute([1, '/api/qr/qr.png']);
                
                // Redireciona com mensagem de sucesso
                header("Location: qrcode.php?status=success");
                exit();
                
            } catch (PDOException $e) {
                // Log do erro em produção
                error_log("Erro ao salvar no banco de dados: " . $e->getMessage());
                header("Location: qrcode.php?status=error");
                exit();
            }
        } else {
            // Log do erro em produção
            error_log("Erro: Não foi possível salvar a imagem QR Code");
            header("Location: qrcode.php?status=error");
            exit();
        }
        
        imagedestroy($im);
    } else {
        header("Location: qrcode.php?status=invalid");
        exit();
    }
} else {
    header("Location: qrcode.php");
    exit();
}