<?php
/*
 * ?? Playlist Manager - Dashboard
 * ?? Version: 1.3.0
 * ?? Last Updated: 29/08/2025
 */
include "includes/header.php";
?>
<style>
/* ================================================== */
/* ====== Tema Material Design 3 (MD3) Dark ====== */
/* ================================================== */

:root {
  /* Paleta de Cores MD3 (Tema Escuro) */
  --md3-primary: #D0BCFF;
  --md3-on-primary: #381E72;
  --md3-primary-container: #4F378B;
  --md3-on-primary-container: #EADDFF;
  
  --md3-background: #1C1B1F;
  --md3-on-background: #E6E0E9;
  
  --md3-surface: #211F26;
  --md3-on-surface: #E6E0E9;
  --md3-surface-container: #2B2930;
  --md3-on-surface-container: #E6E0E9;
  
  --md3-outline: #938F99;
  --md3-shadow: rgba(0, 0, 0, 0.4);
}

body {
  background-color: var(--md3-background);
  color: var(--md3-on-background);
}

/* === Cards: Estilo MD3 === */
.card {
  border-radius: 16px;
  background: var(--md3-surface-container);
  border: none;
  color: var(--md3-on-surface);
  box-shadow: 0 4px 12px var(--md3-shadow);
  transition: transform 0.2s cubic-bezier(0.4, 0, 0.2, 1), box-shadow 0.2s cubic-bezier(0.4, 0, 0.2, 1);
  position: relative;
  overflow: hidden;
}

.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 8px 24px var(--md3-shadow);
}

/* === ??cones e Tipografia === */
.card i {
  font-size: 2.8rem;
  color: var(--md3-primary);
  text-shadow: none;
  animation: none;
  transition: color 0.2s ease;
}

.card:hover i {
  transform: none;
  text-shadow: none;
  color: var(--md3-on-primary-container);
}

.card-title {
  font-weight: 700;
  font-size: 1.35rem;
  color: var(--md3-on-surface);
  margin-bottom: 0.5rem;
  animation: none;
}

.card-text {
  font-size: 0.95rem;
  color: var(--md3-on-surface);
  line-height: 1.6;
}

/* === Bot??es Estilo MD3 === */
.btn-md3-filled {
  background: var(--md3-primary-container);
  color: var(--md3-on-primary-container);
  font-weight: 500;
  border-radius: 20px;
  padding: 0.8rem 1.8rem;
  box-shadow: 0 2px 4px var(--md3-shadow);
  transition: transform 0.2s cubic-bezier(0.4, 0, 0.2, 1), box-shadow 0.2s cubic-bezier(0.4, 0, 0.2, 1);
  width: 100%;
  text-decoration: none;
  cursor: pointer;
}

.btn-md3-filled:hover {
  transform: translateY(-2px);
  box-shadow: 0 4px 8px var(--md3-shadow);
}

/* === Responsividade === */
@media (max-width: 768px) {
  .card i { font-size: 2.4rem; }
  .card-title { font-size: 1.25rem; }
  .btn-md3-filled { padding: 0.7rem 1.5rem; }
}
</style>
<div class="row justify-content-center">

    <div class="col-md-4 col-sm-6 mb-4">
        <div class="card text-center">
            <div class="card-body">
                <i class="fab fa-telegram mb-3"></i>
               <h5 class="card-title">Telegram</h5>
               <p class="card-text">BR TECH</p>
               <a href="https://t.me/brtechprojetos" class="btn btn-md3-filled">ACESSAR</a>
            </div>
        </div>
    </div>
<?php include "includes/footer.php"; ?>
