<?php
//db call
$db = new SQLite3('./api/studiolivecode.db');

//table name
$table_name = "chatbot_studiolivecode";

//current file var
$base_file = basename($_SERVER["SCRIPT_NAME"]);

//create if not
$db->exec("CREATE TABLE IF NOT EXISTS {$table_name}(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, chatbot_link TEXT, dns_id INTEGER, status TEXT)");


// Get current value
$res = $db->query("SELECT * FROM {$table_name} ORDER BY id DESC LIMIT 1");
$row = $res->fetchArray();

// Buscar lista de DNS disponíveis
$dns_res = $db->query("SELECT id, title, url FROM dns ORDER BY title ASC");

// Handle insert/update
if (isset($_POST['submit'])) {
    $chatbot_link = SQLite3::escapeString($_POST['chatbot_link']);
    $dns_id = SQLite3::escapeString($_POST['dns_id']);
    $status = SQLite3::escapeString($_POST['status']);

    if ($row) {
        // Update
        $db->exec("UPDATE {$table_name} SET 
                  chatbot_link = '{$chatbot_link}',
                  dns_id = '{$dns_id}',
                  status = '{$status}'
                  WHERE id = '{$row['id']}'");
    } else {
        // Insert
        $db->exec("INSERT INTO {$table_name}(chatbot_link, dns_id, status) 
                  VALUES('{$chatbot_link}', '{$dns_id}', '{$status}')");
    }

    header("Location: {$base_file}?status=1");
    exit;
}

include ('includes/header.php');
?>

<div class="col-md-8 mx-auto">
    <div class="card-body">
        <div class="card bg-primary text-white">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-comment"></i>Sistema Chatbot</h2>
                </center>
            </div>

            <div class="card-body">
                <?php if ($row && $row['status'] == 'Ativo'): ?>
                    <div class="chatbot-alert success">
                        🤖 Chatbot Ativo!
                    </div>
                <?php elseif ($row && $row['status'] == 'Desativado'): ?>
                    <div class="chatbot-alert danger">
                        ⚠️ Chatbot Desativado!
                    </div>
                <?php endif; ?>

                <div class="col-12">
                    <h3>Configurar Chatbot</h3>
                </div>
                <form method="post">
                    <div class="form-group">
                        <label class="form-label" for="chatbot_link">Link do Chatbot</label>
                        <input class="form-control" name="chatbot_link" type="text" 
                               placeholder="https://example.com/chatbot" 
                               value="<?= $row['chatbot_link'] ?? '' ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="dns_id">Selecionar DNS</label>
                        <select class="form-control" name="dns_id" required>
                            <option value="">Selecione uma DNS</option>
                            <?php 
                            while ($dns = $dns_res->fetchArray()) {
                                $selected = ($row && $row['dns_id'] == $dns['id']) ? 'selected' : '';
                                echo "<option value='{$dns['id']}' {$selected}>
                                        {$dns['title']} ({$dns['url']})
                                      </option>";
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="status">Status do Chatbot</label>
                        <select class="form-control" name="status" required>
                            <option value="Ativo" <?= ($row && $row['status'] == 'Ativo') ? 'selected' : '' ?>>Ativo</option>
                            <option value="Desativado" <?= ($row && $row['status'] == 'Desativado') ? 'selected' : '' ?>>Desativado</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <center>
                            <button class="btn btn-info" name="submit" type="submit">
                                <i class="icon icon-check"></i> Salvar Configurações
                            </button>
                        </center>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.chatbot-alert {
    font-weight: bold;
    padding: 12px 20px;
    border-radius: 30px;
    text-align: center;
    margin-bottom: 15px;
    animation: pulse 1.5s infinite;
    transition: opacity 1s ease-out;
}
.chatbot-alert.success {
    background: #28a745;
    color: #fff;
}
.chatbot-alert.danger {
    background: #dc3545;
    color: #fff;
}
@keyframes pulse {
    0% { transform: scale(1); box-shadow: 0 0 0 rgba(0,0,0,0.3); }
    70% { transform: scale(1.05); box-shadow: 0 0 20px rgba(0,0,0,0.3); }
    100% { transform: scale(1); box-shadow: 0 0 0 rgba(0,0,0,0.3); }
}
</style>

<script>
// Faz a mensagem desaparecer após 2 segundos
setTimeout(() => {
    document.querySelectorAll('.chatbot-alert').forEach(el => {
        el.style.opacity = '0';
        setTimeout(() => el.remove(), 1000); // remove do DOM após sumir
    });
}, 2000);
</script>

<?php include('includes/footer.php'); ?>
</body>
</html>
