<?php
// =========================
// live_game_api.php
// =========================
ini_set('display_errors', 0);

$websiteUrl = "about:blank"; // valor padrão para evitar erro

try {
    $db_path = __DIR__ . '/studiolivecode.db'; // caminho do DB
    $sqlite = new PDO("sqlite:$db_path");
    $sqlite->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Garante que a tabela exista
    $sqlite->exec("CREATE TABLE IF NOT EXISTS live_game_url (
        id INTEGER PRIMARY KEY,
        url TEXT NOT NULL
    )");
    
    // Se não existir o registro com ID=1, cria com placeholder
    $sqlite->exec("INSERT OR IGNORE INTO live_game_url (id, url) VALUES (1, 'https://seusite.com/placeholder')");

    // Pega a URL atual do jogo (ID = 1)
    $stmt = $sqlite->prepare("SELECT url FROM live_game_url WHERE id = 1 LIMIT 1");
    $stmt->execute();
    if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $websiteUrl = htmlspecialchars($row['url']);
    }

} catch (PDOException $e) {
    // Em caso de erro, mostra uma tela amigável
    $websiteUrl = "about:blank";
}

// =========================
// Gerar a página HTML
// =========================
$htmlContent = <<<HTML
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>WebView</title>
    <style>
        body {
            margin: 0;
            overflow: hidden;
            background: black;
        }
        iframe {
            width: 100%;
            height: 100vh;
            border: none;
            background: black;
        }
    </style>
</head>
<body>
    <iframe id="webview" src="$websiteUrl" frameborder="0" allowfullscreen sandbox="allow-scripts allow-same-origin"></iframe>
    <script>
        const iframe = document.getElementById('webview');
        iframe.onload = function() {
            setInterval(function() {
                try { window.scrollBy(0, -10); } catch(e){}
            }, 3000);
        };
    </script>
</body>
</html>
HTML;

// Definir tipo de conteúdo e exibir
header("Content-Type: text/html; charset=utf-8");
echo $htmlContent;
?>
