<?php
header('Content-Type: application/json');

// Caminho do banco SQLite
$dbFile = __DIR__ . '/studiolivecode.db';

if (!file_exists($dbFile)) {
    http_response_code(500);
    echo json_encode(["error" => "Banco de dados não encontrado"]);
    exit;
}

try {
    $db = new PDO("sqlite:$dbFile");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Buscar todas as URLs da tabela dns
    $stmt = $db->query("SELECT id, title, url FROM dns ORDER BY id ASC");
    $dnsList = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($dnsList);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => $e->getMessage()]);
}
