<?php
header('Content-Type: application/json');

// Caminho do banco SQLite
$dbPath = __DIR__ . '/studiolivecode.db';

if (!file_exists($dbPath)) {
    echo json_encode(['error' => 'Banco de dados não encontrado']);
    exit;
}

try {
    // Conectar ao banco
    $pdo = new PDO('sqlite:' . $dbPath);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Pegar ID via GET
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;

    if ($id <= 0) {
        echo json_encode(['error' => 'ID inválido']);
        exit;
    }

    // Buscar URL pelo ID
    $stmt = $pdo->prepare("SELECT id, url FROM dns WHERE id = :id LIMIT 1");
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    $dns = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($dns) {
        echo json_encode($dns);
    } else {
        echo json_encode(['error' => 'DNS não encontrado']);
    }

} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
