<?php
error_reporting(0);
ini_set('display_errors', 0);

/*
 * 🔒 @ Gerenciamento de Testes
 * 🚀 @ Versão: 1.0.0
 * 📅 @ Atualizado: <?= date('d/m/Y') ?>
 */

include "includes/header.php";

$json_file = __DIR__ . "/api/registro_testes.json";

// Função para carregar os testes
function load_tests($file) {
    if (!file_exists($file)) return [];
    $json = file_get_contents($file);
    $data = json_decode($json, true);
    return is_array($data) ? $data : [];
}

// Função para salvar os testes
function save_tests($file, $data) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
}

// Ações POST
if (isset($_POST["delete_one"])) {
    $device_id = $_POST["device_id"];
    $tests = load_tests($json_file);
    $tests = array_filter($tests, fn($t) => $t["device_id"] !== $device_id);
    save_tests($json_file, array_values($tests));
    $msg = "✅ Registro do dispositivo $device_id excluído!";
}

if (isset($_POST["delete_all"])) {
    save_tests($json_file, []);
    $msg = "✅ Todos os registros foram excluídos!";
}

// Carregar os testes atuais
$tests = load_tests($json_file);
?>

<style>
    .test-card {
        border-radius: 15px;
        box-shadow: 0 6px 20px rgba(0,0,0,0.15);
        border: none;
        margin-bottom: 15px;
    }
    .btn-delete {
        background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
        border: none;
        border-radius: 30px;
        padding: 8px 20px;
        font-weight: 600;
        color: #fff;
        transition: all 0.3s;
    }
    .btn-delete:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(231, 76, 60, 0.4);
    }
    .btn-delete-all {
        background: linear-gradient(135deg, #d35400 0%, #e67e22 100%);
        border: none;
        border-radius: 30px;
        padding: 12px 30px;
        font-weight: 600;
        color: #fff;
        transition: all 0.3s;
        margin-bottom: 20px;
    }
    .btn-delete-all:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(211, 84, 0, 0.4);
    }
</style>

<div class="col-md-8 mx-auto mt-5">
    <?php if(isset($msg)): ?>
        <div class="alert alert-success"><?= $msg ?></div>
    <?php endif; ?>

    <div class="text-center mb-3">
        <form method="post">
            <button type="submit" name="delete_all" class="btn btn-delete-all">
                <i class="fas fa-trash-alt"></i> Excluir Todos os Registros
            </button>
        </form>
    </div>

    <?php if(empty($tests)): ?>
        <div class="alert alert-info">Nenhum teste registrado no momento.</div>
    <?php else: ?>
        <?php foreach($tests as $test): ?>
            <div class="card test-card">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h5><i class="fas fa-mobile-alt"></i> <?= htmlspecialchars($test["device_id"]) ?></h5>
                        <small>Timestamp: <?= date("d/m/Y H:i:s", $test["timestamp"]) ?></small>
                    </div>
                    <form method="post" onsubmit="return confirm('Tem certeza que deseja excluir este registro?');">
                        <input type="hidden" name="device_id" value="<?= htmlspecialchars($test["device_id"]) ?>">
                        <button type="submit" name="delete_one" class="btn btn-delete">
                            <i class="fas fa-trash"></i> Excluir
                        </button>
                    </form>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<?php include "includes/footer.php"; ?>
</body>
</html>
