<?php
header('Content-Type: application/json');

// User-Agent esperado (deve ser o mesmo que você colocou no app)
$allowedAgent = 'MyAppName/1.0';

// Pega o User-Agent da requisição
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

// Verifica se o User-Agent contém a string esperada
if (strpos($userAgent, $allowedAgent) === false) {
    http_response_code(403); // Proibido
    echo json_encode(['Error' => 'Acesso negado: Não econtrado a lista de ids dos Vods e Series']);
    exit();
}

// Caminho para o banco SQLite
$db_path = __DIR__ . '/studiolivecode.db';

try {
    $db = new PDO("sqlite:$db_path");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Busca todas as URLs na tabela dns
    $stmt = $db->prepare("SELECT url FROM dns");
    $stmt->execute();

    $dns_list = $stmt->fetchAll(PDO::FETCH_COLUMN, 0);

    // Retorna JSON com as URLs (array de strings)
    echo json_encode($dns_list);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Erro interno do servidor: ' . $e->getMessage()]);
}

exit();
?>
