<?php
$jsonFile = 'registro_testes.json';
$deviceId = $_POST['device_id'] ?? '';
if (!$deviceId) exit('No device_id');

$data = [];
if (file_exists($jsonFile)) {
    $data = json_decode(file_get_contents($jsonFile), true) ?: [];
}

// Verifica se o device_id já existe
$alreadyExists = false;
foreach ($data as $entry) {
    if (isset($entry['device_id']) && $entry['device_id'] === $deviceId) {
        $alreadyExists = true;
        break;
    }
}

// Só adiciona se não existir
if (!$alreadyExists) {
    $data[] = ['device_id' => $deviceId, 'timestamp' => time()];
    file_put_contents($jsonFile, json_encode($data, JSON_PRETTY_PRINT));
}

echo json_encode(['success' => true, 'alreadyExists' => $alreadyExists]);
?>
