<?php
/*
 * @ https://scripts.studiolivecode.com.br 
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 17/06/2024
 */

include "includes/header.php";

// Caminho do arquivo JSON
$jsonFile = 'alerta_status.json';

// Carrega os dados atuais ou cria estrutura padrão
if (file_exists($jsonFile)) {
    $config = json_decode(file_get_contents($jsonFile), true);
} else {
    $config = [
        "alerta_vencimento_ativo" => true,
        "mensagem_vencimento_hoje" => "Sua assinatura vence hoje!",
        "mensagem_vencimento_dias" => "Sua assinatura vence em %d dia(s)!"
    ];
    file_put_contents($jsonFile, json_encode($config, JSON_PRETTY_PRINT));
}

// Processa o formulário
if (isset($_POST["submit"])) {
    $config = [
        "alerta_vencimento_ativo" => isset($_POST["alerta_vencimento_ativo"]),
        "mensagem_vencimento_hoje" => $_POST["mensagem_vencimento_hoje"],
        "mensagem_vencimento_dias" => $_POST["mensagem_vencimento_dias"]
    ];
    
    file_put_contents($jsonFile, json_encode($config, JSON_PRETTY_PRINT));
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}

// HTML com design moderno e emojis
echo '
<div class="container py-5">
    <div class="row justify-content-center animate__animated animate__fadeInUp">
        <div class="col-md-8 col-lg-6">
            <div class="card shadow-lg border-0 rounded-lg transform-on-hover">
                <div class="card-header bg-gradient-warning text-white text-center py-4 rounded-top-lg">
                    <h2 class="mb-0 fs-3"><i class="fas fa-bell me-3 fa-shake"></i> Configuração de Alertas ⚠️✨</h2>
                </div>
                <div class="card-body p-5">
                    <form method="post">
                        <div class="mb-4 form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="alerta_vencimento_ativo" name="alerta_vencimento_ativo" ' . ($config["alerta_vencimento_ativo"] ? 'checked' : '') . '>
                            <label class="form-check-label" for="alerta_vencimento_ativo">
                                <i class="fas fa-power-off me-2"></i> Alertas de Vencimento Ativos 🔔
                            </label>
                        </div>
                        
                        <div class="mb-4">
                            <label for="mensagem_vencimento_hoje" class="form-label d-flex align-items-center">
                                <i class="fas fa-calendar-day me-2 text-danger"></i> Mensagem para vencimento HOJE 🚨:
                            </label>
                            <input type="text" class="form-control form-control-lg border-danger" id="mensagem_vencimento_hoje" name="mensagem_vencimento_hoje" 
                                   value="' . htmlspecialchars($config["mensagem_vencimento_hoje"]) . '" 
                                   placeholder="Ex: ⚠️ Sua assinatura expira hoje! Renove já!">
                            <small class="text-warning"><i class="fas fa-lightbulb me-1"></i> Use emojis para deixar mais atrativo! 🎯</small>
                        </div>
                        
                        <div class="mb-5">
                            <label for="mensagem_vencimento_dias" class="form-label d-flex align-items-center">
                                <i class="fas fa-calendar-week me-2 text-primary"></i> Mensagem para vencimento FUTURO 📅:
                            </label>
                            <input type="text" class="form-control form-control-lg border-primary" id="mensagem_vencimento_dias" name="mensagem_vencimento_dias" 
                                   value="' . htmlspecialchars($config["mensagem_vencimento_dias"]) . '" 
                                   placeholder="Ex: ⏳ Sua assinatura vence em %d dia(s)!">
                            <small class="text-warning"><i class="fas fa-lightbulb me-1"></i> O símbolo %d será substituído pelo número de dias! 🔢</small>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button class="btn btn-success btn-lg custom-btn-glow" name="submit" type="submit">
                                <i class="fas fa-save me-2"></i> Salvar Configurações 💾
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card-footer bg-light text-center py-3 rounded-bottom-lg">
                    <small class="text-muted"><i class="fas fa-info-circle me-1"></i> As alterações terão efeito imediato! ⚡</small>
                </div>
            </div>
        </div>
    </div>
</div>
';

// Exibe mensagem de sucesso se houver
if (isset($_GET['status']) && $_GET['status'] == 1) {
    echo '
    <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 11">
        <div class="toast show" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header bg-success text-white">
                <strong class="me-auto"><i class="fas fa-check-circle"></i> Sucesso!</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">
                Configurações salvas com sucesso! ✅
            </div>
        </div>
    </div>
    ';
}

include "includes/footer.php";
?>