<?php

// Define o cabeçalho para indicar que a resposta é um JSON
header('Content-Type: application/json');

// Configuração do banco de dados
$db_path = 'studiolivecode.db';

try {
    // Conectar ao banco de dados SQLite
    $db = new PDO('sqlite:' . $db_path);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Buscar configuração do chatbot - versão mais flexível
    $stmt = $db->prepare("
        SELECT cs.chatbot_link, d.url as dns_url 
        FROM chatbot_studiolivecode cs 
        LEFT JOIN dns d ON cs.dns_id = d.id 
        WHERE cs.status LIKE '%ativo%' OR cs.status LIKE '%Ativo%' OR cs.status LIKE '%ACTIVE%'
        OR cs.status = '1' OR cs.status = 'true'
        ORDER BY cs.id DESC
        LIMIT 1
    ");
    
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Se não encontrar com status ativo, pega qualquer um
    if (!$config || empty($config['chatbot_link'])) {
        $stmt = $db->prepare("
            SELECT cs.chatbot_link, d.url as dns_url 
            FROM chatbot_studiolivecode cs 
            LEFT JOIN dns d ON cs.dns_id = d.id 
            ORDER BY cs.id DESC 
            LIMIT 1
        ");
        $stmt->execute();
        $config = $stmt->fetch(PDO::FETCH_ASSOC);
    }
    
    if (!$config || empty($config['chatbot_link'])) {
        throw new Exception("Nenhum chatbot encontrado no banco de dados");
    }
    
    $bot_url = $config['chatbot_link'];
    $dns_url = $config['dns_url'] ?? 'http://ztech.blog';

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Erro de conexão com o banco de dados: " . $e->getMessage()]);
    exit;
} catch (Exception $e) {
    http_response_code(404);
    echo json_encode(["error" => $e->getMessage()]);
    exit;
}

// JSON que será enviado ao bot
$json = json_encode([
 "receiveMessageAppId" => "com.whatsapp",
 "receiveMessagePattern" => ["*"],
 "senderName" => "API DE TESTE",
 "groupName" => "",
 "senderMesage" => "api_cadastro",
 "senderMessage" => "api_cadastro",
 "messageDateTime" => time(),
 "isMessageFromGroup" => false
]);

// Requisição cURL
$ch = curl_init($bot_url);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
 'Content-Type: application/json',
 'Content-Length: ' . strlen($json)
]);

$response = curl_exec($ch);

if ($response === false) {
    http_response_code(500);
    echo json_encode(["error" => "Erro na requisição: " . curl_error($ch)]);
    exit;
}
curl_close($ch);

// Decodificar resposta
$data = json_decode($response, true);

if (is_null($data)) {
    http_response_code(400);
    echo json_encode(["error" => "Resposta inválida do chatbot."]);
    exit;
}

// Extrair username / password
$username = null;
$password = null;
$payUrl= null;

if (isset($data['username']) && isset($data['password'])) {
 $username = $data['username'];
 $password = $data['password'];
 $payUrl= $data['payUrl'] ?? null;
} elseif (isset($data['data'][0]['message'])) {
 $user_pass = explode("|", $data['data'][0]['message']);
 $username = $user_pass[0] ?? null;
 $password = $user_pass[1] ?? null;
 $payUrl= $data['data'][0]['payUrl'] ?? null;
}

// Montar URL IPTV
$iptv_url = null;
if (!empty($username) && !empty($password)) {
 $iptv_url = $dns_url . "/get.php?username=" . $username . "&password=" . $password . "&type=m3u_plus&output=ts";
}

// Montar resultado final
$resultado = [
 "username" => $username,
 "password" => $password,
 "payUrl"=> $payUrl,
 "iptv_url" => $iptv_url,
 "dns_utilizado" => $dns_url,
 "bot_utilizado" => $bot_url,
 "raw_response" => $data
];

// Imprime a resposta JSON
echo json_encode($resultado, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
exit;