<?php
session_start();
$mensagem = '';
$uploadDir = __DIR__ . '/img/';
$destinoFinal = $uploadDir . 'qr.png';

// Verifica se enviou o formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['qr_image'])) {
    // Cria a pasta se não existir
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $arquivoTemporario = $_FILES['qr_image']['tmp_name'];
    $check = getimagesize($arquivoTemporario);

    if ($check !== false) {
        if (move_uploaded_file($arquivoTemporario, $destinoFinal)) {
            $mensagem = [
                'type' => 'success',
                'text' => 'Imagem enviada com sucesso como <strong>qr.png</strong>'
            ];
        } else {
            $mensagem = [
                'type' => 'error',
                'text' => 'Erro ao mover o arquivo'
            ];
        }
    } else {
        $mensagem = [
            'type' => 'error',
            'text' => 'O arquivo enviado não é uma imagem válida'
        ];
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload de QR Code</title>
    
    <!-- Fontes e Ícones -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://kit.fontawesome.com/3794d2f89f.js" crossorigin="anonymous"></script>
    
    <style>
        :root {
            --primary-color: #1a213c;
            --primary-hover: #0f1427;
            --secondary-color: #2d3a6e;
            --accent-color: #4a5fc1;
            --success-color: #28a745;
            --error-color: #dc3545;
            --bg-dark: #121829;
            --bg-light: #f8f9fa;
            --card-bg: rgba(26, 33, 60, 0.9);
            --text-light: #ffffff;
            --text-dark: #212529;
            --border-color: #2a3250;
            --transition-speed: 0.3s;
        }

        body, html {
            height: 100%;
            width: 100%;
            margin: 0;
            padding: 0;
            background-color: #121829;
        }

        .main-container {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px; /* Adiciona um pouco de padding ao redor em telas menores */
        }

        .card {
            background: var(--card-bg);
            border-radius: 12px;
            padding: 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            border: 1px solid var(--border-color);
            backdrop-filter: blur(8px);
            transition: transform var(--transition-speed) ease;
            width: 90%;
            max-width: 900px;
            display: flex;
            flex-direction: row;
            align-items: center;
            justify-content: space-between;
        }

        .card:hover {
            transform: translateY(-5px);
        }

        .card-title {
            font-size: 1.75rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            color: var(--text-light);
            position: relative;
            text-align: center;
        }

        .card-title::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background: var(--accent-color);
            border-radius: 3px;
        }

        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            animation: fadeIn 0.5s ease;
        }

        .alert-success {
            background-color: rgba(40, 167, 69, 0.15);
            color: var(--success-color);
            border-left: 4px solid var(--success-color);
        }

        .alert-error {
            background-color: rgba(220, 53, 69, 0.15);
            color: var(--error-color);
            border-left: 4px solid var(--error-color);
        }

        .alert i {
            font-size: 1.25rem;
        }

        .upload-form {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .form-group {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }

        label {
            font-weight: 500;
            color: var(--text-light);
        }

        .file-input-wrapper {
            position: relative;
            overflow: hidden;
            display: inline-block;
            width: 100%;
        }

        .file-input-button {
            width: 100%;
            padding: 1rem;
            border: 2px dashed var(--border-color);
            border-radius: 8px;
            background: rgba(255, 255, 255, 0.05);
            color: var(--text-light);
            text-align: center;
            cursor: pointer;
            transition: all var(--transition-speed) ease;
        }

        .file-input-button:hover {
            border-color: var(--accent-color);
            background: rgba(255, 255, 255, 0.1);
        }

        .file-input-wrapper input[type="file"] {
            position: absolute;
            left: 0;
            top: 0;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }

        .submit-btn {
            padding: 1rem;
            background-color: var(--accent-color);
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all var(--transition-speed) ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .submit-btn:hover {
            background-color: var(--secondary-color);
            transform: translateY(-2px);
        }

        .submit-btn i {
            font-size: 1.1rem;
        }

        .qr-preview {
            margin-top: 2rem;
            text-align: center;
            padding: 1.5rem;
            background: rgba(0, 0, 0, 0.2);
            border-radius: 8px;
            border: 1px dashed var(--border-color);
            animation: fadeIn 0.8s ease;
        }

        .qr-preview h3 {
            margin-bottom: 1rem;
            color: var(--text-light);
            font-weight: 500;
        }

        .qr-preview img {
            max-width: 200px;
            height: auto;
            border-radius: 8px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            transition: transform var(--transition-speed) ease;
        }

        .qr-preview img:hover {
            transform: scale(1.05);
        }

        .file-info {
            margin-top: 0.5rem;
            font-size: 0.85rem;
            color: var(--text-light);
            opacity: 0.7;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @media (max-width: 600px) {
            body {
                padding: 1rem;
            }

            .card {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="main-container">
        <div class="card">
            <h1 class="card-title">Upload de QR Code</h1>
            
            <?php if (!empty($mensagem)): ?>
                <div class="alert alert-<?= $mensagem['type'] ?>">
                    <i class="fas fa-<?= $mensagem['type'] === 'success' ? 'check-circle' : 'exclamation-circle' ?>"></i>
                    <span><?= $mensagem['text'] ?></span>
                </div>
            <?php endif; ?>

            <form class="upload-form" method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="qr_image">Selecione uma imagem</label>
                    <div class="file-input-wrapper">
                        <div class="file-input-button">
                            <i class="fas fa-cloud-upload-alt"></i> Clique para selecionar
                        </div>
                        <input type="file" name="qr_image" id="qr_image" accept="image/png, image/jpeg, image/gif" required>
                    </div>
                    <small class="file-info">Formatos suportados: PNG, JPG, GIF (Máx. 5MB)</small>
                </div>
                
                <button type="submit" class="submit-btn">
                    <i class="fas fa-save"></i> Salvar como qr.png
                </button>
            </form>

            <?php if (file_exists($destinoFinal)): ?>
                <div class="qr-preview">
                    <h3>QR Code atual</h3>
                    <img src="img/qr.png?<?= time() ?>" alt="QR Code Atual">
                    <div class="file-info">
                        Modificado em: <?= date('d/m/Y H:i', filemtime($destinoFinal)) ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Atualiza o texto do botão de upload com o nome do arquivo selecionado
            const fileInput = document.getElementById('qr_image');
            const fileInputButton = document.querySelector('.file-input-button');
            
            if (fileInput && fileInputButton) {
                fileInput.addEventListener('change', function() {
                    if (this.files && this.files[0]) {
                        fileInputButton.innerHTML = `<i class="fas fa-file-image"></i> ${this.files[0].name}`;
                    } else {
                        fileInputButton.innerHTML = `<i class="fas fa-cloud-upload-alt"></i> Clique para selecionar`;
                    }
                });
            }

            // Feedback visual ao enviar o formulário
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                form.addEventListener('submit', function(e) {
                    const submitBtn = form.querySelector('button[type="submit"]');
                    if (submitBtn) {
                        submitBtn.disabled = true;
                        submitBtn.innerHTML = `<i class="fas fa-spinner fa-spin"></i> Processando...`;
                    }
                });
            });
        });
    </script>
</body>
</html>