<?php
session_start();
include 'includes/header.php';

// Caminho para o JSON
$jsonFile = __DIR__ . '/init/7b41aa22-45db-4fe9-bed9-6018e9852c1b';

// Lê o JSON atual
$data = json_decode(file_get_contents($jsonFile), true);

// Se o formulário foi enviado
$mensagem = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $novaSenha = $_POST['nova_senha'] ?? '';

    if (!empty($novaSenha)) {
        $data['defaultPassword'] = $novaSenha;
        file_put_contents($jsonFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        $mensagem = "<p class='msg sucesso'>Senha atualizada com sucesso!</p>";
    } else {
        $mensagem = "<p class='msg erro'>Por favor, digite uma senha.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Alterar Senha</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            padding: 0;
        }

        .form-container {
            background-color: #ffffff;
            padding: 30px 40px;
            border-radius: 12px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            margin: 50px auto; /* Centraliza apenas o formulário, com margem em cima e embaixo */
            text-align: center;
        }

        h2 {
            margin-bottom: 20px;
            color: #333;
        }

        input[type="text"] {
            width: 100%;
            padding: 12px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 8px;
            font-size: 16px;
        }

        button {
            width: 100%;
            padding: 12px;
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
        }

        button:hover {
            background-color: #45a049;
        }

        .msg {
            margin-bottom: 15px;
            font-weight: bold;
        }

        .sucesso {
            color: green;
        }

        .erro {
            color: red;
        }
    </style>
</head>
<body>

<div class="form-container">
    <h2>Alterar Senha do APP</h2>
    <?= $mensagem ?>
    <form method="POST">
        <input type="text" name="nova_senha" placeholder="Digite a nova senha" value="<?= htmlspecialchars($data['defaultPassword']) ?>">
        <button type="submit">Salvar</button>
    </form>
</div>

</body>
</html>
