<?php

session_start(); // Inicia a sessão


// Conectar ao banco de dados SQLite
$db = new SQLite3('./api/.boxbrdb.db');

// Recuperar os dados do DNS que será atualizado
$res = $db->query('SELECT * FROM dns WHERE id=\'' . $_GET['update'] . '\'');
$row = $res->fetchArray();
$id = $row['id'];
$url = $row['url'];

// Quando o formulário for enviado
if (isset($_POST['submit'])) {
    // Atualizar o DNS no banco de dados
    $db->exec('UPDATE dns SET url=\'' . $_POST['url'] . '\' WHERE id=\'' . $_POST['id'] . '\'');

    // Reescrever o arquivo JSON com os dados atualizados
    updateDnsJsonFile($db);

    // Fechar conexão com o banco de dados
    $db->close();

    // Redirecionar de volta para a lista de DNSs
    header('Location: dns.php');
    exit();
}

// Função para atualizar o arquivo JSON com os DNSs do banco de dados no formato simples de array de strings
function updateDnsJsonFile($db) {
    $res = $db->query('SELECT * FROM dns');
    $dnsArray = [];

    // Recupera todos os DNSs do banco e adiciona diretamente as URLs no array
    while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
        // Adiciona a URL diretamente ao array
        $dnsArray[] = $row['url'];
    }

    // Codifica os dados como JSON no formato simples (array de strings)
    $jsonData = json_encode($dnsArray, JSON_PRETTY_PRINT);

    // Caminho do arquivo JSON
    $jsonFilePath = 'api/dns_file.json';

    // Reescreve o arquivo JSON com os dados atualizados
    file_put_contents($jsonFilePath, $jsonData);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit DNS</title>
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body, html {
            height: 100%;
            margin: 0;
            font-family: sans-serif;
            background-color: #000;
            position: relative;
        }

        #particles-js {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
        }

        .form-container {
            position: relative;
            z-index: 1;
            background: rgba(50, 50, 50, 0.8);
            color: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
            text-align: center;
            margin-top: 50px;
            width: 80%;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        h1 {
            color: #1cc88a;
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        label {
            display: block;
            margin-bottom: 5px;
            color: #ccc;
        }

        .form-control {
            width: 100%;
            padding: 10px;
            border: 1px solid #444;
            border-radius: 8px;
            background-color: #333;
            color: white;
            box-sizing: border-box;
        }

        .btn-primary {
            background-color: #1cc88a;
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        .btn-primary:hover {
            background-color: #14855c;
        }
    </style>
</head>
<body>

    <div id="particles-js"></div>
    <?php include 'includes/header.php'; ?>

    <div class="form-container">
        <h1>Edit DNS</h1>
        <form method="post">
            <input type="hidden" name="id" value="<?php echo $id; ?>">
            <div class="form-group">
                <label for="url">DNS</label>
                <input type="text" class="form-control" id="url" name="url" placeholder="http://your-dns-url.com" value="<?php echo $url; ?>">
            </div>
            <button type="submit" name="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>

    <script>
        particlesJS('particles-js', {
            "particles": {
                "number": {
                    "value": 80,
                    "density": {
                        "enable": true,
                        "value_area": 800
                    }
                },
                "color": {
                    "value": "#1cc88a"
                },
                "shape": {
                    "type": "circle",
                    "stroke": {
                        "width": 0,
                        "color": "#000000"
                    }
                },
                "opacity": {
                    "value": 0.5,
                    "random": true,
                    "anim": {
                        "enable": true,
                        "speed": 1,
                        "opacity_min": 0.1
                    }
                },
                "size": {
                    "value": 3,
                    "random": true,
                    "anim": {
                        "enable": true,
                        "speed": 40,
                        "size_min": 0.1
                    }
                },
                "line_linked": {
                    "enable": true,
                    "distance": 150,
                    "color": "#1cc88a",
                    "opacity": 0.4,
                    "width": 1
                },
                "move": {
                    "enable": true,
                    "speed": 6,
                    "direction": "none",
                    "random": false,
                    "straight": false,
                    "out_mode": "out",
                    "attract": {
                        "enable": false,
                        "rotateX": 600,
                        "rotateY": 600
                    }
                }
            },
            "interactivity": {
                "detect_on": "canvas",
                "events": {
                    "onhover": {
                        "enable": true,
                        "mode": "repulse"
                    },
                    "onclick": {
                        "enable": true,
                        "mode": "push"
                    }
                }
            },
            "retina_detect": true
        });
    </script>

</body>
</html>